function Results_DIbefore_SA
% EEGLAB toolbox required
% bs, mod, spindles, sleep in dB


clc
close all
clear
before=1;

pathfigure='.\';

load('dati_SSO_SA');
load('labels_sleep_SA');
load('dati_spindles_ferr_SA');
load('bandsPower_SA')

d_D=(SSO.Detezioni_patch)-(SSO.Detezioni_ctrl); %SSO detection rate
d_D_Sp=(spindles.Detezioni_patch)-(spindles.Detezioni_ctrl);d_D_Sp=real(d_D_Sp); %spindle detection rate

%band power
d_bp=TABdb(2:2:end,:,:)-TABdb(1:2:end,:,:);

for i=1:105
    d_SSO{i,22}=d_bp(:,i,1)';  % delta 0.5-3.9Hz
    d_SSO{i,23}=d_bp(:,i,2)';
    d_SSO{i,24}=d_bp(:,i,3)';
    d_SSO{i,25}=d_bp(:,i,4)';
    d_SSO{i,26}=d_bp(:,i,5)';%%%%%%%%% % sigma 9-15Hz
    d_SSO{i,27}=d_bp(:,i,6)';
    d_SSO{i,28}=d_bp(:,i,7)';
end

labelss(22:28)=band_labels;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


labels_Spindle={'SP_pwr', 'SP_fdom'}; % sp power 9-15Hz, NON dB
labels_Spindle_2=['rate_SP_MPF', 'event rate', 'event size', labels_sleep];

stile_elettrodi='pts';%'ptsnumbers'%'pts';%'labelpts';%'pts';%

for j=[1:11 13:17]%[1 2 3 4 5 9 11 13 14 15 17]
    R(1:105)=NaN;
    Pval2(1:105)=NaN;
    if j==13,R(:,12)=NaN;end
    for i=unique([SSO.F_L_105 SSO.F_R_105 SSO.TP_L_105 SSO.TP_R_105 SSO.O_105])%105
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% NB da
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% cambiare
        if (j==10)||(j==16)
            d_SSO{i,j}=SSO.feat_O_patch{i,j}(2:2:end)-SSO.feat_O_ctrl{i,j}(1:2:end)+SSO.feat_O_patch{i,j-1}(2:2:end)-SSO.feat_O_ctrl{i,j-1}(1:2:end);
        else
            d_SSO{i,j}=SSO.feat_O_patch{i,j}(2:2:end)-SSO.feat_O_ctrl{i,j}(1:2:end);
        end
    end
    labelss{j}=labels_sleep{j};
end

labelss{10}='mod  l+h sigma'
labelss{16}='BS  l+h sigma'

for j=1:2%[1 2 3 4 5 9 11 13 14 15 17]
    for i=unique([SSO.F_L_105 SSO.F_R_105 SSO.TP_L_105 SSO.TP_R_105 SSO.O_105])%105
        if j==1
            % spindle power in dB
            d_SSO{i,j+17}=10*log10(spindles.feat_O_patch{i,j}(2:2:end))-10*log10(spindles.feat_O_ctrl{i,j}(1:2:end));
        else
            d_SSO{i,j+17}=spindles.feat_O_patch{i,j}(2:2:end)-spindles.feat_O_ctrl{i,j}(1:2:end);
        end
    end
    labelss{j+17}=labels_Spindle{j};
end


for i=1:105
    d_SSO{i,20}=d_D(:,i)';
    d_SSO{i,21}=d_D_Sp(:,i)';
end

labelss{20}='det_rate_SSO';
labelss{21}='det_rate_Sp';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


figure
subplot(121)
topoplot([],SSO.chn128m(unique([SSO.O_105])),...
    'emarker',{'x',[1 .8 0],12,3},'hcolor','none','intrad',.5,'whitebk','on');

hold on;topoplot([],SSO.chn128m(unique([SSO.roi_pfr_105])),...
    'emarker',{'x','r',12,3},'hcolor','none','intrad',.5,'whitebk','on');

hold on;topoplot([],SSO.chn128m(unique([SSO.roi_ctrl_105])),...
    'emarker',{'x','k',12,3},'hcolor','none','intrad',.5,'whitebk','on');

hold on;topoplot([],SSO.chn128m,...
    'emarker',{'.','k',3,1},'hcolor','k','intrad',.5,'whitebk','on');


cd(pathfigure)
scrsz = get(groot,'ScreenSize'); h=gcf; set(h,'Position',[1 1 (scrsz(3)-80) (scrsz(4)-80)]);
print (gcf,'-dtiff' ,'-r150',['mappa_ROI'])
%


R1(1:28)=NaN;
R2(1:28)=NaN;

Pval1=[];
Pval2=[];

Pval1(1:28)=NaN;
Pval2(1:28)=NaN;

P1(1:28)=NaN;
P2(1:28)=NaN;


cd (pathfigure)

for j=[ 4 7 16 18 20 21 22 26]%[7 9 18 19 20 21]
    
    ROI1=[];
    ROI2=[];
    %ROI3=[];
    
    for i=unique([SSO.roi_ctrl_105])%105
        ROI1=[ROI1 d_SSO{i,j}'];
    end
    mROI1=nanmean(ROI1,2);
    
    if before
        for i=unique([SSO.O_105])%105
            ROI2=[ROI2 d_SSO{i,j}'];
        end
        mROI2=nanmean(ROI2,2);
    else
        for i=unique([SSO.roi_pfr_105])%105
            ROI2=[ROI2 d_SSO{i,j}'];
        end
        mROI2=nanmean(ROI2,2);
    end
    
    
    [P1(j),~]=signrank(squeeze(mROI1));
    [P2(j),~]=signrank(squeeze(mROI2));
    %[~,P(j)]=ttest(mROI1);
    [R1(j),Pval1(j)]=corr(mROI1,spindles.DIbefore,'type','spearman', 'rows','pairwise');
    [R2(j),Pval2(j)]=corr(mROI2,spindles.DIbefore,'type','spearman', 'rows','pairwise');
    
    %plot(spindles.DIbefore,mROI1,'ko','markersize',20,'markerfacecolor','k','markeredgecolor','w','linewidth',2)
    %hold on
    plotta(spindles.DIbefore,mROI2,'orkk','o')
    % plot(spindles.DIbefore,mROI2,'ko','markersize',20,'markerfacecolor','k','markeredgecolor','w','linewidth',2)
    
    %gtext(num2str([j R1(j) Pval1(j) R2(j) Pval2(j)]))
    %  title(['correlazioni DIbefore - ' labelss{j} ' ' num2str(R2(j)) 'p=' num2str(Pval2(j))],'interpreter','none')
    
    axis square
    set(gca,'box','off','xtick',[0.4 .55 .7 .85 1],'linewidth',6)%,'xlim',[-4 2],'xtick',[-4 -2 0 2]
    E=ylim;set(gca,'ytick',[(E(1)) (diff(E)/4+E(1)) (2*diff(E)/4+E(1)) (3*diff(E)/4+E(1)) (E(2))])
    set(gca,'fontsize',10)
    xlabel ('DI before','fontsize',10,'interpreter','none')
    ylabel (labelss{j},'fontsize',10,'interpreter','none')
    
    scrsz = get(groot,'ScreenSize'); h=gcf; set(h,'Position',[1 1 (scrsz(3)-80) (scrsz(4)-80)]); print (gcf,'-dtiff' ,'-r150',['correlazioni DIbefore - ' labelss{j}])
    
end

[h, crit_p, adj_p]=fdr_bh([P1(~isnan(P1)) P2(~isnan(P2))],0.05,'pdep','yes')
%[p_fdr,p_mas]=fdr([0.012 0.033 0.012 0.0038 0.009 0.96 0.002 .82 .36 .85 .85 .88 .86 .7 ],0.05);

%ctrl [.82 .36 .85 .85 .88 .86 .7 ]
[h, crit_p, adj_p]=fdr_bh([Pval1(~isnan(Pval1)) Pval2(~isnan(Pval2))],0.05,'pdep','yes')


%[h, crit_p, adj_p]=fdr_bh([0.009 0.0022 0.0045 0.033 0.011 0.0022 .82 .36 .55 .69 .88 .7 ],0.05,'pdep','yes');% 'dep'== Benjamini & Yekutieli (2001),  Bejnamini & Hochberg

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for j=[4 7 16 18 20 21 22 26]%[7 9 18 19 20 21]
    R(1:105)=NaN;
    Pval2(1:105)=NaN;
    P(1:105)=NaN;
    %  if j==13,R(:,12)=NaN;end
    for i=unique([SSO.F_L_105 SSO.F_R_105 SSO.TP_L_105 SSO.TP_R_105 SSO.O_105])%105
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        if sum(isnan(d_SSO{i,j}))<5
            [P(i),~]=signrank(squeeze(d_SSO{i,j}'));
            %[~,P(i)]=ttest(squeeze(d_SSO{i,j}'));
            [R(i),Pval2(i)]=corr(d_SSO{i,j}',spindles.DIbefore,'type','spearman', 'rows','pairwise');
        end
    end
    
    R=R(~isnan(R));
    CRobust=R;
    Pval2=Pval2(~isnan(Pval2));
    PvalRobust=Pval2;
    P=P(~isnan(P));
    figure
    subplot(121)
    topoplot(CRobust,SSO.chn128m(unique([SSO.F_L_105 SSO.F_R_105 SSO.TP_L_105 SSO.TP_R_105 SSO.O_105])),'maplimits',[floor(min(CRobust)*10)./10 0],...
        'numcontour',0,'electrodes',stile_elettrodi,'EMARKERSIZE',1,'conv','off','intrad',.5,'whitebk','on');%
    

    if before
        hold on;topoplot([],SSO.chn128m(unique([SSO.O_105])),'emarker',{'x','y',12,3},'hcolor','none','intrad',.5,'whitebk','on');
    else
        hold on;topoplot([],SSO.chn128m(unique([SSO.O_105])),'emarker',{'x','y',12,3},'hcolor','none','intrad',.5,'whitebk','on');
        hold on;topoplot([],SSO.chn128m(unique([SSO.roi_pfr_105])),'emarker',{'x','r',12,3},'hcolor','none','intrad',.5,'whitebk','on');
    end
    hold on;topoplot([],SSO.chn128m(unique([SSO.roi_ctrl_105])),'emarker',{'x','k',12,3},'hcolor','none','intrad',.5,'whitebk','on');
    
    title(['correlazioni DIbefore - ' labelss{j}],'interpreter','none')
    [cmap]=buildcmap('bbcw');colormap(cmap);
    h=colorbar('southoutside');
    pos=get(h,'position');pos(4)=pos(4)*1.5;
    set(h,'xtick',[-.7 -.5 -.25 0],'xticklabel',{'-0.7','-0.5','-0.25','>0'},'linewidth',0.1,'position',pos)
    %%%%%%%%%%%%%%%%%%%%%%%%%
    subplot(122)
    medch=trimmean(cell2mat(d_SSO(:,j))',10);

    limiti=[-prctile(abs(medch),95) prctile(abs(medch),95)];
    
    topoplot(medch,SSO.chn128m(unique([SSO.F_L_105 SSO.F_R_105 SSO.TP_L_105 SSO.TP_R_105 SSO.O_105])),'maplimits',limiti,'numcontour',0,'electrodes',stile_elettrodi,...
        'EMARKERSIZE',1,'conv','off','intrad',.5,'whitebk','on');
    hold on;
    
    title(['deltaNotti_' labelss{j}],'interpreter','none')
    
    cd(pathfigure)
    scrsz = get(groot,'ScreenSize'); h=gcf; set(h,'Position',[1 1 (scrsz(3)-80) (scrsz(4)-80)]); print (gcf,'-dtiff' ,'-r150',['mappe_correlazioni_delta_' labelss{j} '_DIbefore'])
end
end

function plotta(x,y,mappaColori,simboloMarker)
figure, hold on
[cmap]=buildcmap(mappaColori);

for i=1:length(x)
    colorePunto=cmap(ceil((x(i)-min(x))./(max(x)-min(x))*254+1),:);
    plot(x(i),y(i),simboloMarker,'markersize',24,'markerfacecolor',colorePunto,'markeredgecolor','w','linewidth',2)
end
end

function [cmap]=buildcmap(colors)
% [cmap]=buildcmap(colors)
%
% This function can be used to build your own custom colormaps. Imagine if
% you want to display rainfall distribution map. You want a colormap which
% ideally brings rainfall in mind, which is not achiveved by colormaps such
% as winter, cool or jet and such. A gradient of white to blue will do the
% task, but you might also use a more complex gradient (such as
% white+blue+red or colors='wbr'). This function can be use to build any
% colormap using main colors rgbcmyk. In image processing, w (white) can be
% used as the first color so that in the output, the background (usually
% with 0 values) appears white. In the example of rainfall map, 'wb' will
% produce a rainfall density map where the background (if its DN values are
% 0) will appear as white.
%
% Inputs:
%  colors: string (char) of color codes, any sequence of rgbcmywk
%  representing different colors (such as 'b' for blue) is acceptable. If a
%  gradient of white to blue is needed, colors would be 'wb'; a rainbow of
%  white+blue+red+green would be 'wbrg'.
%
% Example:
%  [cmap]=buildcmap('wygbr');
% %try the output cmap:
% im=imread('cameraman.tif');
% imshow(im), colorbar
% colormap(cmap) %will use the output colormap
%
% First version: 14 Feb. 2013
% sohrabinia.m@gmail.com
%--------------------------------------------------------------------------
if nargin<1
    colors='wrgbcmyk';
end
if ~ischar(colors)
    error(['Error! colors must be a variable of type char with '...
        'color-names, such as ''r'', ''g'', etc., '...
        'type ''help buildcmap'' for more info']);
end
ncolors=length(colors)-1;
bins=round(255/ncolors);
% diff1=255-bins*ncolors;
vec=zeros(300,3);
switch colors(1)
    case 'o'
        vec(1,:)=[1 .3 0];
    case 'w'
        vec(1,:)=1;
    case 'r'
        vec(1,:)=[1 0 0];
    case 'g'
        vec(1,:)=[0 1 0];
    case 'b'
        vec(1,:)=[0 0 1];
    case 'c'
        vec(1,:)=[0 1 1];
    case 'm'
        vec(1,:)=[1 0 1];
    case 'y'
        vec(1,:)=[1 1 0];
    case 'k'
        vec(1,:)=[0 0 0];
end
for i=1:ncolors
    beG=(i-1)*bins+1;
    enD=i*bins+1; %beG,enD
    switch colors(i+1)
        case 'w'
            vec(beG:enD,1)=linspace(vec(beG,1),1,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),1,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),1,bins+1)';%colors(i+1),beG,enD,
        case 'r'
            vec(beG:enD,1)=linspace(vec(beG,1),1,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),0,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),0,bins+1)';%colors(i+1),beG,enD
        case 'g'
            vec(beG:enD,1)=linspace(vec(beG,1),0,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),1,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),0,bins+1)';%colors(i+1),beG,enD
        case 'b'
            vec(beG:enD,1)=linspace(vec(beG,1),0,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),0,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),1,bins+1)';%colors(i+1),beG,enD
        case 'c'
            vec(beG:enD,1)=linspace(vec(beG,1),0,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),1,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),1,bins+1)';%colors(i+1),beG,enD
        case 'm'
            vec(beG:enD,1)=linspace(vec(beG,1),1,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),0,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),1,bins+1)';
        case 'y'
            vec(beG:enD,1)=linspace(vec(beG,1),1,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),1,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),0,bins+1)';
        case 'k'
            vec(beG:enD,1)=linspace(vec(beG,1),0,bins+1)';
            vec(beG:enD,2)=linspace(vec(beG,2),0,bins+1)';
            vec(beG:enD,3)=linspace(vec(beG,3),0,bins+1)';
    end
end
cmap=vec(1:bins*ncolors,:);
end %end of buildcmap
